# -*- coding: utf-8 -*-
import logging
from requests import Session
from requests.adapters import HTTPAdapter
from urllib3 import Retry

from six.moves.urllib_parse import urljoin

logger = logging.getLogger(__name__)


class Client(object):
    def __init__(self, host):
        self._host = host
        self._session = Session()
        self._session.mount('http://', HTTPAdapter(max_retries=Retry(
            total=3,
            read=3,
            connect=3,
            backoff_factor=0.1,
            status_forcelist=(500, 502, 503, 504),
        )))

    def top_directions_by_date_window(self, national_version, request, timeout=5):
        raw_response = self._session.post(
            urljoin(
                self._host,
                'search_methods/v1/top_directions_by_date_window/{}'.format(national_version)),
            json=request,
            timeout=timeout,
        )
        raw_response.raise_for_status()
        response = raw_response.json()
        if response['status'] != 'ok':
            logger.error('bad price index response: %s', response)
            return []
        return response['data']
