# -*- coding: utf-8 -*-
import logging
from argparse import ArgumentParser

import ydb
from yql.api.v1.client import YqlClient
from sandbox.projects.Travel.resources import dicts
from sandbox.common.rest import Client as SandboxClient
from sandbox.common.proxy import OAuth

from travel.avia.library.python.lib_yt.client import configured_client
from travel.avia.avia_statistics.top_airlines_updater.lib.updater import TopAirlinesUpdater
from travel.avia.avia_statistics.top_airlines_updater.lib.table import TopAirlinesTable
from travel.avia.avia_statistics.top_airlines_updater.lib.collector import TopAirlinesCollector
from travel.avia.avia_statistics.landing_routes import get_landing_routes
from travel.avia.library.python.ydb.session_manager import YdbSessionManager
from travel.avia.library.python.sandbox.resource_fetcher import ResourceFetcher
from travel.library.python.dicts.avia.company_repository import CompanyRepository

logger = logging.getLogger(__name__)


def main():
    parser = ArgumentParser()

    parser.add_argument('--debug', action='store_true', default=False)

    parser.add_argument('--yt-token', help='YT token', required=True)
    parser.add_argument('--yt-proxy', default='hahn')

    parser.add_argument('--yql-token', help='YQL token', required=True)

    parser.add_argument('--sandbox-token', help='Sandbox token', required=True)

    parser.add_argument('--ydb-cluster', default='ydb-ru-prestable.yandex.net:2135')
    parser.add_argument('--ydb-database', default='/ru-prestable/ticket/testing/avia_statistics')
    parser.add_argument('--flights-ydb-table', default='flights')
    parser.add_argument('--ydb-table', default='top_airlines')
    parser.add_argument('--ydb-token', help='YDB token', required=True)

    parser.add_argument('--batch', help='Batch size', default=1000)

    arguments = parser.parse_args()

    logging.basicConfig(level=logging.INFO)

    if arguments.debug:
        logging.basicConfig(level=logging.DEBUG)

    yt_client = configured_client(proxy=arguments.yt_proxy, token=arguments.yt_token)
    yql_client = YqlClient(token=arguments.yql_token)

    ydb_config = ydb.DriverConfig(
        endpoint=arguments.ydb_cluster,
        database=arguments.ydb_database,
        auth_token=arguments.ydb_token,
    )
    session_manager = YdbSessionManager(ydb_config)

    top_airlines_table = TopAirlinesTable(session_manager, arguments.ydb_database, arguments.ydb_table)
    landing_routes = get_landing_routes(yt_client)

    sandbox_oauth = OAuth(arguments.sandbox_token)
    sandbox_client = SandboxClient(auth=sandbox_oauth)
    resource_fetcher = ResourceFetcher(sandbox_client, sandbox_oauth)

    company_repository = CompanyRepository()
    company_resource_data = resource_fetcher.fetch_latest_ready(dicts.TRAVEL_DICT_AVIA_COMPANY_PROD)
    company_repository.load_from_string(company_resource_data)

    top_airlines_collector = TopAirlinesCollector(yql_client, company_repository)
    top_airlines_updater = TopAirlinesUpdater(
        landing_routes,
        top_airlines_collector,
        top_airlines_table,
        arguments.batch,
    )
    top_airlines_updater.update()


if __name__ == '__main__':
    main()
