# -*- coding: utf-8 -*-
import logging
from typing import Set
from datetime import datetime, timedelta

from travel.avia.avia_statistics.top_airlines_updater.lib.table import TopAirlinesTable, TopAirlines
from travel.avia.avia_statistics.top_airlines_updater.lib.collector import TopAirlinesCollector
from travel.avia.avia_statistics.landing_routes import LandingRoute

logger = logging.getLogger(__name__)


class TopAirlinesUpdater(object):
    TTL_TIMEDELTA = timedelta(days=7, hours=6)

    def __init__(self, landing_routes, top_airlines_collector, top_airlines_table, batch_size):
        # type: (Set[LandingRoute], TopAirlinesCollector, TopAirlinesTable, int) -> None
        self._landing_routes = landing_routes
        self._top_airlines_collector = top_airlines_collector
        self._top_airlines_table = top_airlines_table
        self._batch_size = batch_size

    def update(self):
        self._top_airlines_table.create_if_doesnt_exist()

        processed = 0
        batch = []
        for from_id, to_id, nv, top_airlines in self._top_airlines_collector.collect():
            if (from_id, to_id, nv) not in self._landing_routes:
                continue
            expires_at = datetime.utcnow() + self.TTL_TIMEDELTA
            batch.append(TopAirlines(from_id, to_id, nv, top_airlines, expires_at))
            if len(batch) == self._batch_size:
                self._top_airlines_table.replace_batch(batch)
                processed += len(batch)
                batch = []
                logger.info('Processed: %d routes', processed)
        if len(batch):
            self._top_airlines_table.replace_batch(batch)
            processed += len(batch)
            logger.info('Processed: %d routes', processed)
        logger.info('All routes were stored into YDB')
