# -*- coding: utf-8 -*-
import logging
from datetime import datetime, date
from argparse import ArgumentParser

import ydb
from yql.api.v1.client import YqlClient

from travel.avia.avia_statistics.updaters.city_to.month_and_year_prices_by_city_to_updater.lib.collector import (
    MonthAndYearPricesByCityToCollector
)
from travel.avia.avia_statistics.updaters.city_to.month_and_year_prices_by_city_to_updater.lib.table import (
    MonthAndYearPricesByCityToTable
)
from travel.avia.avia_statistics.updaters.city_to.month_and_year_prices_by_city_to_updater.lib.updater import (
    MonthAndYearPricesByCityToUpdater
)
from travel.avia.library.python.ydb.session_manager import YdbSessionManager


def main():
    parser = ArgumentParser()

    parser.add_argument('--debug', action='store_true', default=False)

    parser.add_argument('--yql-token', help='YQL token', required=True)

    parser.add_argument('--ydb-cluster', default='ydb-ru-prestable.yandex.net:2135')
    parser.add_argument('--ydb-database', default='/ru-prestable/ticket/testing/avia_statistics')
    parser.add_argument('--ydb-table', default='month_and_year_prices_by_city_to')
    parser.add_argument('--ydb-token', help='YDB token', required=True)

    parser.add_argument('--batch', help='Batch size', default=1000)

    parser.add_argument('--redirects-log-directory', help='Avia redirects log directory',
                        default='//home/avia/logs/avia-redir-balance-by-day-log')
    parser.add_argument('--landing-cities-table', help='City to landing cities',
                        default='//home/avia/avia-statistics/city-to-landing-cities')
    parser.add_argument('--date', help='Date', default=date.today().isoformat())

    arguments = parser.parse_args()

    logging.basicConfig(level=logging.INFO)

    if arguments.debug:
        logging.basicConfig(level=logging.DEBUG)

    yql_client = YqlClient(token=arguments.yql_token)
    collector = MonthAndYearPricesByCityToCollector(
        yql_client=yql_client,
        redirects_log_path=arguments.redirects_log_directory,
        landing_cities_table=arguments.landing_cities_table,
    )
    ydb_config = ydb.DriverConfig(
        endpoint=arguments.ydb_cluster,
        database=arguments.ydb_database,
        auth_token=arguments.ydb_token,
    )

    session_manager = YdbSessionManager(ydb_config)
    table = MonthAndYearPricesByCityToTable(session_manager, arguments.ydb_database, arguments.ydb_table)
    updater = MonthAndYearPricesByCityToUpdater(
        collector,
        table,
        arguments.batch,
    )
    target_date = datetime.strptime(arguments.date, '%Y-%m-%d').date()
    updater.update(target_date)


if __name__ == '__main__':
    main()
