# -*- coding: utf-8 -*-
import logging
from argparse import ArgumentParser

import ydb

from travel.avia.avia_statistics.updaters.city_to.nearest_cities_updater.lib.updater import CityToNearestCitiesUpdater
from travel.avia.avia_statistics.updaters.city_to.nearest_cities_updater.lib.table import CityToNearestCitiesTable
from travel.avia.avia_statistics.landing_cities import iter_landing_cities
from travel.avia.library.python.lib_yt.client import configured_client
from travel.avia.library.python.backend_client import BackendClient
from travel.avia.library.python.ydb.session_manager import YdbSessionManager

logger = logging.getLogger(__name__)


def main():
    parser = ArgumentParser()

    parser.add_argument('--debug', action='store_true', default=False)
    parser.add_argument(
        '--avia-backend-host',
        help='avia-backend host',
        default='http://backend.production.avia.yandex.net',
    )
    parser.add_argument('--default-max-distance-km', default=200)
    parser.add_argument('--yt-token', help='YT token', required=True)
    parser.add_argument('--yt-proxy', default='hahn')

    parser.add_argument('--ydb-cluster', default='ydb-ru-prestable.yandex.net:2135')
    parser.add_argument('--ydb-database', default='/ru-prestable/ticket/testing/avia_statistics')
    parser.add_argument('--ydb-table', default='city_to_nearest_cities')
    parser.add_argument('--ydb-token', help='YDB token', required=True)
    parser.add_argument('--ydb-batch', help='YDB upsert request batch size', default=1000)

    arguments = parser.parse_args()

    logging.basicConfig(level=logging.INFO)

    if arguments.debug:
        logging.basicConfig(level=logging.DEBUG)

    yt_client = configured_client(proxy=arguments.yt_proxy, token=arguments.yt_token)
    ydb_config = ydb.DriverConfig(
        endpoint=arguments.ydb_cluster,
        database=arguments.ydb_database,
        auth_token=arguments.ydb_token,
    )
    session_manager = YdbSessionManager(ydb_config)

    city_to_nearest_cities_table = CityToNearestCitiesTable(
        session_manager,
        arguments.ydb_database,
        arguments.ydb_table,
    )
    backend_client = BackendClient(arguments.avia_backend_host)
    landing_cities = list(iter_landing_cities(yt_client))

    city_to_nearest_cities_updater = CityToNearestCitiesUpdater(
        yt_client=yt_client,
        landing_cities=landing_cities,
        city_to_nearest_cities_table=city_to_nearest_cities_table,
        avia_backend_client=backend_client,
        ydb_batch_size=arguments.ydb_batch,
        default_max_distance_km=arguments.default_max_distance_km,
    )
    city_to_nearest_cities_updater.update()


if __name__ == '__main__':
    main()
