import logging
import sys

import click

from travel.avia.avia_statistics.updaters.recent_direction_popularity.lib.runner import run_func

logger = logging.getLogger(__name__)


@click.group()
def main():
    logging.basicConfig(level=logging.INFO, stream=sys.stdout)


@main.command()
@click.option('--table', 'table_name', type=str, required=True, default='recent_direction_popularity')
@click.option('--days', type=int, required=True, default=30)
def run(table_name: str, days: int) -> None:
    run_func(table_name, days)


if __name__ == '__main__':
    main()
