from pydantic import BaseSettings
import ydb

from travel.avia.avia_statistics.updaters.recent_direction_popularity.lib.table import DirectionPopularityTable
from travel.avia.avia_statistics.updaters.recent_direction_popularity.lib.updater import Updater
from travel.avia.library.python.lib_yt.client import configured_client
from travel.avia.library.python.ydb.session_manager import YdbSessionManager


class YtSettings(BaseSettings):
    token: str
    proxy: str = 'hahn'

    class Config:
        env_prefix = 'YT_'


class YdbSettings(BaseSettings):
    token: str
    cluster: str
    database: str

    class Config:
        env_prefix = 'YDB_'


def run_func(table_name: str, days: int) -> None:
    yt_settings = YtSettings()
    client = configured_client(yt_settings.proxy, yt_settings.token)
    ydb_settings = YdbSettings()
    ydb_config = ydb.DriverConfig(
        endpoint=ydb_settings.cluster,
        database=ydb_settings.database,
        auth_token=ydb_settings.token,
    )
    session_manager = YdbSessionManager(ydb_config)
    storage = DirectionPopularityTable(
        session_manager=session_manager, database=ydb_settings.database, table_name=table_name
    )
    storage.create_if_doesnt_exist()

    updater = Updater(yt_client=client, storage=storage)
    updater.update(days=days)
