# coding: utf8
from __future__ import absolute_import

import re

paths = [
    (r'^/rest/airlines/\d+/flights/[^/]+/reviews$', '/rest/airlines/ID/flights/NUMBER/reviews'),
    (r'^/rest/airlines/abc/[^/]+/[^/]+/[^/]+/.+$', '/rest/airlines/abc/NV/LANG/A/B'),
    (r'^/rest/airlines/airline_info/\d+$', '/rest/airlines/airline_info/ID'),
    (r'^/rest/airlines/flights_to_city/\d+$', '/rest/airlines/flights_to_city/ID'),
    (r'^/rest/airlines/index/[^/]+/[^/]+$', '/rest/airlines/index/NV/LANG'),
    (r'^/rest/airlines/popular/[^/]+/[^/]+/\d+$', '/rest/airlines/popular/NV/LANG/ID'),
    (r'^/rest/airlines/similar_airlines/[^/]+/[^/]+/\d+$', '/rest/airlines/similar_airlines/NV/LANG/ID'),
    (r'^/rest/currencies/[^/]+/[^/]+$', '/rest/currencies/NV/LANG'),
    (r'^/rest/currencies/rates/[^/]+/[^/]+$', '/rest/currencies/rates/NV/LANG'),
    (r'^/rest/geo/country/.*$', '/rest/geo/country/ID'),
    (r'^/rest/holidays/[^/]+/[^/]+/\d+/from_city/\d+$', '/rest/holidays/NV/LANG/ID/from_city/ID'),
    (r'^/rest/holidays/[^/]+/[^/]+/from_city/\d+$', '/rest/holidays/NV/LANG/from_city/ID'),
    (r'^/rest/partners/popular_by_route/[^/]+/[^/]+/[^/]+/[^/]+$', '/rest/partners/popular_by_route/NV/LANG/FROM/TO'),
]

requests = [
    (r'^.+name=bestOffers', '/api/bestOffers'),
    (r'^.+name=cheaperThan', '/api/cheaperThan'),
    (r'^.+name=choice', '/api/choice'),
    (r'^.+name=clientSettlement', '/api/clientSettlement'),
    (r'^.+name=countryDirections', '/api/countryDirections'),
    (r'^.+name=country', '/api/country'),
    (r'^.+name=currency', '/api/currency'),
    (r'^.+name=defaultSuggest', '/api/defaultSuggest'),
    (r'^.+name=direction', '/api/direction'),
    (r'^.+name=disclaimer', '/api/disclaimer'),
    (r'^.+name=dohopVendors', '/api/dohopVendors'),
    (r'^.+name=flightNumbersToCompanyIds', '/api/flightNumbersToCompanyIds'),
    (r'^.+name=geoCities', '/api/geoCities'),
    (r'^.+name=geoCountries', '/api/geoCountries'),
    (r'^.+name=geoLookup', '/api/geoLookup'),
    (r'^.+name=geoSearch', '/api/geoSearch'),
    (r'^.+name=goodPrice', '/api/goodPrice'),
    (r'^.+name=info', '/api/info'),
    (r'^.+name=livestore', '/api/livestore'),
    (r'^.+name=minPrices', '/api/minPrices'),
    (r'^.+name=nearDirections', '/api/nearDirections'),
    (r'^.+name=nearDistances', '/api/nearDistances'),
    (r'^.+name=neighbourCountryDirections', '/api/neighbourCountryDirections'),
    (r'^.+name=order', '/api/order'),
    (r'^.+name=partners', '/api/partners'),
    (r'^.+name=recipeOffers', '/api/recipeOffers'),
    (r'^.+name=recipeOffer', '/api/recipeOffer'),
    (r'^.+name=recipes', '/api/recipes'),
    (r'^.+name=recipe', '/api/recipe'),
    (r'^.+name=redirectData', '/api/redirectData'),
    (r'^.+name=schedule', '/api/schedule'),
    (r'^.+name=searchKey', '/api/searchKey'),
    (r'^.+name=search', '/api/search'),
    (r'^.+name=seoDirectionText', '/api/seoDirectionText'),
    (r'^.+name=settlementImage', '/api/settlementImage'),
    (r'^.+name=settlement', '/api/settlement'),
    (r'^.+name=similarDirections', '/api/similarDirections'),
    (r'^.+name=stations', '/api/stations'),
    (r'^.+name=station', '/api/station'),
    (r'^.+name=topFlights', '/api/topFlights'),
    (r'^.+name=update', '/api/update'),
]


def nginx_log_normalize_record(record):
    for r, title in requests:
        if re.match(r, record.request):
            return title

    for p, title in paths:
        if re.match(p, record.uri):
            return title

    return record.uri
