# -*- encoding: utf-8 -*-
from __future__ import absolute_import

import os  # noqa

from travel.avia.backend.main.settings import *  # noqa
from travel.avia.library.python.common.settings.environment import EnvironmentSettings

CURRENT_DC = os.getenv('DEPLOY_NODE_DC', None)
YANDEX_ENVIRONMENT_TYPE = os.getenv('YANDEX_ENVIRONMENT_TYPE', 'development')

MYSQL_CLUSTER_ID = os.getenv('AVIA_MYSQL_CLUSTER_ID')

EnvironmentSettings.apply(globals())

BLACKBOX_URL = os.getenv('BLACKBOX_URL')

CACHES = {
    'default': default_cache(), # noqa
    'shared_cache': shared_cache(), # noqa
    'replica_set': CACHES.pop('replica_set'), # noqa
}

if YANDEX_ENVIRONMENT_TYPE == 'testing':
    ENVIRONMENT = 'testing'

elif YANDEX_ENVIRONMENT_TYPE == 'stress':
    pass

elif YANDEX_ENVIRONMENT_TYPE == 'production':
    pass

elif YANDEX_ENVIRONMENT_TYPE == 'development':
    PRECACHE = []
    DEBUG = True
    MAINTENANCE_DB_NAME = None
    DATABASES['default'].update({  # noqa
        'HOST': os.getenv('AVIA_MYSQL_HOST', 'localhost'),
        'NAME': os.getenv('AVIA_MYSQL_DATABASE', 'avia'),
        'USER': os.getenv('AVIA_MYSQL_USER', 'root'),
        'PASSWORD': os.getenv('AVIA_MYSQL_PASSWORD', ''),
    })
    DATABASES['writable'] = DATABASES['default']  # noqa
    TEST_DB_NAME = os.getenv('AVIA_MYSQL_TEST_DATABASE', 'avia_tests')

ADMINS = (
    ('Alexander Kuznetsov', 'bfa@yandex-team.ru'),
)
MANAGERS = ADMINS

from library.python.django.utils import patch_settings_for_arcadia  # noqa
patch_settings_for_arcadia()
