import os
import logging.config

LOG_PATH = os.getenv('AVIA_LOG_PATH', '/var/log/yandex-avia-backend')
if os.getenv('YA_TEST_RUNNER', False):
    LOG_PATH = './logs'

YT_LOG_PATH = os.getenv('AVIA_YT_LOG_PATH', '/ephemeral/var/log/yandex-avia-backend')

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'root': {
        'level': 'INFO',
        'handlers': [
            'tree_handler',
            'sentry',
            'error',
            'traceback'
        ]
    },
    'formatters': {
        'traceback': {
            '()': 'ylog.ExceptionFormatter',
            'format': '%(levelname)s %(asctime)s %(process)d %(pathname)s:%(funcName)s:%(lineno)d %(message)s',
            'full': True,
            'show_locals': True
        },
        'verbose': {
            'format': '%(levelname)s %(asctime)s: %(message)s',
            'datefmt': '%Y-%m-%d %H:%M:%S'
        },
        'error': {
            '()': 'ylog.ExceptionFormatter',
            'format': '%(asctime)s %(name)-15s %(levelname)-10s %(message)s'
        },
        'message_only': {
            'format': '%(message)s',
        },
    },
    'filters': {
    },
    'handlers': {
        'sentry': {
            'level': 'ERROR',
            'class': 'raven.contrib.django.raven_compat.handlers.SentryHandler',
            'tags': {
                'environment': os.getenv('YANDEX_ENVIRONMENT_TYPE', 'unknown'),
                'DEPLOY_NODE_DC': os.getenv('DEPLOY_NODE_DC'),
                'DEPLOY_STAGE_ID': os.getenv('DEPLOY_STAGE_ID'),
            }
        },
        'error': {
            'class': 'travel.avia.library.python.common.utils.logs.WatchedFileHandler',
            'filename': os.path.join(LOG_PATH, 'main', 'error.log'),
            'formatter': 'error',
            'level': 'ERROR',
        },
        'traceback': {
            'class': 'travel.avia.library.python.common.utils.logs.WatchedFileHandler',
            'filename': os.path.join(LOG_PATH, 'main', 'traceback.log'),
            'formatter': 'traceback',
            'level': 'ERROR',
        },
        'tree_handler': {
            'level': 'INFO',
            'class': 'travel.avia.library.python.common.utils.logs.ArcadiaFileTreeHandler',
            'base_path': LOG_PATH,
            'remove_prefix': 'travel.avia.backend',
            'formatter': 'verbose',
        },
        'root_tree_handler_message_only': {
            'level': 'INFO',
            'class': 'travel.avia.library.python.common.utils.logs.FileTreeHandler',
            'base_path': YT_LOG_PATH,
            'formatter': 'message_only',
        }
    },
    'loggers': {
        'django': {
            'handlers': ['error', 'traceback'],
            'level': 'INFO',
        },
    }
}

if os.getenv('DEPLOY_UNIT_ID') is not None:
    LOGGING['root']['handlers'].append('deploy_handler')  # noqa
    for logger in LOGGING['loggers'].values():  # noqa
        logger['handlers'].append('deploy_handler')
    LOGGING['formatters']['deploy'] = {  # noqa
        '()': 'cloud_logger.formatters.DeployJsonFormatter',
        'format': '%(name)s: %(message)s',
        'datefmt': '%Y-%m-%d %H:%M:%S',
    }
    LOGGING['handlers']['deploy_handler'] = {  # noqa
        'level': 'INFO',
        'class': 'logging.StreamHandler',
        'formatter': 'deploy',
    }


def apply_logging_config():
    from raven.conf import setup_logging as raven_setup_logging
    from raven.handlers.logging import SentryHandler

    from travel.avia.library.python.error_booster.raven.unified_agent import RavenErrorBoosterUnifiedAgentClient

    logging.config.dictConfig(LOGGING)

    error_booster_host = os.getenv('ERROR_BOOSTER_HTTP_HOST', None)
    error_booster_port = os.getenv('ERROR_BOOSTER_HTTP_PORT', None)

    if error_booster_host and error_booster_port:
        raven_client = RavenErrorBoosterUnifiedAgentClient(
            error_booster_host=error_booster_host,
            error_booster_port=error_booster_port,
            service='backend',
            environment=os.getenv('YANDEX_ENVIRONMENT_TYPE'),
            dc=os.getenv('DEPLOY_NODE_DC'),
        )
        sentry_handler = SentryHandler(raven_client)
        sentry_handler.setLevel(logging.WARNING)
        raven_setup_logging(sentry_handler)
