# -*- encoding: utf-8 -*-
from __future__ import absolute_import

import logging
import django.db.utils


from travel.avia.backend.main.api.processors import process_fields, validate_params
from travel.avia.backend.main.lib.exceptions import ApiException

log = logging.getLogger(__name__)
db_error_log = logging.getLogger('error.db')


class ApiHandler(object):
    PARAMS_SCHEMA = None
    TYPE_SCHEMA = None
    MULTI = False
    IS_RAW_SCHEMA = False

    def __init__(self, *args, **kwargs):
        self.extra_context = None

    def process(self, params, fields):
        raise NotImplementedError()

    def preprocess_params(self, params):
        return params

    def preprocess_fields(self, fields):
        return fields

    def __call__(self, params, fields):
        params_schema = self.PARAMS_SCHEMA()

        try:
            params = self.preprocess_params(params)
            params = validate_params(params_schema, params)

            fields = self.preprocess_fields(fields)
            fields = process_fields(self.TYPE_SCHEMA, fields)

            result = self.process(params, fields)
        except django.db.utils.OperationalError:
            db_error_log.info('Db Operational Error', exc_info=True)
            raise

        # так как могут спокойно вернуть пустой массив.
        if result is None:
            return None

        if self.IS_RAW_SCHEMA:
            return result

        context = {
            'params': params,
            'fields': fields
        }

        if self.extra_context:
            context.update(self.extra_context)
        schema = self.TYPE_SCHEMA(only=fields.keys() or None, context=context)

        result = schema.dump(result, many=self.MULTI)

        if not result.errors:
            return result.data

        raise ApiException('dump error', result.errors)
