# -*- encoding: utf-8 -*-
from __future__ import absolute_import

import ujson

from marshmallow import Schema
from marshmallow.schema import MarshalResult
from marshmallow.utils import get_value


def camelcase():
    yield unicode.lower
    while True:
        yield unicode.capitalize


def underscore_to_camelcase(value):
    c = camelcase()
    return ''.join(c.next()(unicode(x)) if x else '_' for x in value.split('_'))


def camelcase_dict(d):
    return {
        underscore_to_camelcase(key): value
        for key, value in d.items()
    }


def convert_keys(d):
    # convert python reserverd words
    WORDS = ['from']

    for word in WORDS:
        word_ = '%s_' % word
        if word_ in d:
            d[word] = d[word_]
            del d[word_]

    return camelcase_dict(d)


class TypeSchema(Schema):
    class Meta:
        json_module = ujson

    def get_attribute(self, attr, obj, default):
        value = get_value(attr, obj, default)

        if callable(value):
            return value()

        return value

    def dump(self, *args, **kwargs):
        result = super(TypeSchema, self).dump(*args, **kwargs)
        data = result.data

        if not data:
            return result

        if isinstance(data, dict):
            return MarshalResult(convert_keys(data), result.errors)

        if isinstance(data, list):
            return MarshalResult([convert_keys(i) for i in data], result.errors)

        return result
