# -*- encoding: utf-8 -*-
from __future__ import absolute_import

import re

from travel.avia.backend.main.lib.exceptions import ApiException

first_cap_re = re.compile('(.)([A-Z][a-z]+)')
all_cap_re = re.compile('([a-z0-9])([A-Z])')


def _convert_camelcase_to_undescore(name):
    s1 = first_cap_re.sub(r'\1_\2', name)
    return all_cap_re.sub(r'\1_\2', s1).lower()


def validate_params(params_schema, params):
    params = params or {}

    if not isinstance(params, dict):
        raise ApiException('wrong params type', is_critical=False)

    params = {
        _convert_camelcase_to_undescore(key): value
        for key, value in params.items()
    }

    expected_params_keys = params_schema.fields.keys()
    params_keys = params.keys()
    not_exist_keys = list(set(params_keys) - set(expected_params_keys))

    if not_exist_keys:
        raise ApiException('not exist params {}'.format({
            'params': not_exist_keys
        }), is_critical=False)

    params = params_schema.load(params)

    if params.errors:
        raise ApiException(
            'params are not valid', params.errors,
            is_critical=False
        )

    return params.data


def process_fields(type_schema_kls, fields):
    if not fields:
        return {}

    fields_dict = {}
    for field in list(fields):
        if isinstance(field, basestring):
            field = _convert_camelcase_to_undescore(field)
            fields_dict[field] = {
                'params': {},
                'fields': []
            }
        elif isinstance(field, dict):
            name = field['name']
            name = _convert_camelcase_to_undescore(name)
            fields_dict[name] = {
                'params': field.get('params', {}),
                'fields': field.get('fields', []),
            }
        else:
            raise ApiException('wrong object in fields', {
                'fields': [field]
            }, is_critical=False)

    expected_keys = type_schema_kls._declared_fields.keys()
    expected_keys += type_schema_kls.opts.fields
    fields_keys = fields_dict.keys()
    not_exist_keys = list(set(fields_keys) - set(expected_keys))

    if not_exist_keys:
        raise ApiException('not exist fields', {
            'fields': not_exist_keys
        }, is_critical=False)

    return fields_dict
