# -*- encoding: utf-8 -*-
from __future__ import absolute_import

from travel.avia.backend.main.lib.exceptions import ApiException


TYPES = {}
# Список хендлеров которые были запрошены в момент инициализации
# После регистрации всех хендлеров по этому списку нужно проверить что всё на месте
_GET_TYPES_INIT_LIST = []


class NoHandlerError(ApiException):
    def __init__(self, name):
        super(NoHandlerError, self).__init__('Unknown type %s' % name)


def register_type(name, handler):
    TYPES[name] = handler


def unregister_type(name):
    del TYPES[name]


def get_handler(name):
    """
        оборачиваем получение во враппер,
        потому что на момент вызова хендлер может быть незарегистрирован
    """

    _GET_TYPES_INIT_LIST.append(name)

    def wrapper(*args, **kwargs):
        handler = TYPES.get(name)

        if not handler:
            raise NoHandlerError(name)

        return handler(*args, **kwargs)

    return wrapper


def _check_handlers():
    for name in _GET_TYPES_INIT_LIST:
        if name not in TYPES:
            raise Exception(u'Тип %s был запрошен, но незарегистрирован', name)


def register_types(types):
    for name, handler in types:
        register_type(name, handler)

    _check_handlers()
