# -*- encoding: utf-8 -*-
from __future__ import absolute_import

import flask
from django.utils.translation import get_language
from marshmallow import fields

from travel.avia.backend.main.lib.recipes.airline import get_airline_directions
from travel.avia.backend.main.lib.settlement_serializer import SettlementSerializer
from travel.avia.backend.main.api_types.recipe_offers import (
    fill_image_in_offers, RecipeOffersHandler, get_extra_ids, DEFAULT_LIMIT, RecipeOffersParams
)
from travel.avia.backend.main.api_types.settlement import get_settlement, fill_related_fields as fill_settlement_related_fields


class AirlineRecipeOffersParams(RecipeOffersParams):
    slug = fields.Str(required=True)


class AirlineRecipeOffersHandler(RecipeOffersHandler):
    PARAMS_SCHEMA = AirlineRecipeOffersParams

    def process(self, params, fields):
        offers = get_airline_directions(
            get_settlement(params.get('from_id')),
            params.get('when'),
            params.get('return_date'),
            self._make_passengers(params),
            get_extra_ids(params.get('extra_ids', [])),
            params.get('limit') or DEFAULT_LIMIT,
            params.get('slug'),
        )

        fill_settlement_related_fields([o.city_to for o in offers])
        fill_image_in_offers(offers)

        settlement_serializer = SettlementSerializer()
        lang = get_language()
        nv = flask.g.national_version

        return [
            self._serialize_offer(o, settlement_serializer, nv, lang) for o in
            offers
        ]
