# -*- encoding: utf-8 -*-
from __future__ import absolute_import

from django.db.models import Count

from marshmallow import Schema, fields

from travel.avia.backend.main.api_types.partners import PartnerSchema
from travel.avia.library.python.avia_data.models import BalanceRedirect
from travel.avia.library.python.common.models.partner import Partner
from travel.avia.backend.main.api.api_schema import TypeSchema
from travel.avia.backend.main.api.api_handler import ApiHandler


class BalanceSchema(Schema):
    partner = fields.Nested(PartnerSchema)
    total = fields.Number()


class BalanceParams(TypeSchema):
    left_date = fields.Date(required=True)
    right_date = fields.Date(required=True)
    partner_code_list = fields.List(fields.Str(), required=False)
    national_version_list = fields.List(fields.Str(), required=False)
    pp_list = fields.List(fields.Int(), required=False)


class BalanceHandler(ApiHandler):
    # TODO: таблица, на которую настроен этот хэндлер давным-давно перестала заполняться. Следует удалить
    PARAMS_SCHEMA = BalanceParams
    TYPE_SCHEMA = BalanceSchema
    MULTI = True

    def process(self, params, fields):
        left_date = params["left_date"]
        right_date = params["right_date"]
        partner_code_list = params.get('partner_code_list')
        national_version_list = params.get('national_version_list')
        pp_list = params.get('pp_list')

        db_filter = {
            'eventdate__gte': left_date,
            'eventdate__lte': right_date,
            'filtered': False,
        }

        if partner_code_list:
            db_filter['partner__code__in'] = partner_code_list

        if national_version_list:
            db_filter['national_version__in'] = national_version_list

        if pp_list:
            db_filter['pp__in'] = pp_list

        redirects = BalanceRedirect.objects.filter(**db_filter).values('partner_id').annotate(total=Count('filtered'))

        partner_ids = [r['partner_id'] for r in redirects]
        partner_cache = {p.id: p for p in Partner.objects.filter(id__in=partner_ids)}

        for r in redirects:
            yield {
                'partner': partner_cache.get(r['partner_id']),
                'total': r['total']
            }
