# -*- encoding: utf-8 -*-
from __future__ import absolute_import

from django.utils.html import escape
from marshmallow import Schema, fields

from travel.avia.library.python.common.lib.mail import SmailikClient

from travel.avia.backend.main.api.api_handler import ApiHandler


class BugMailParams(Schema):
    login = fields.Str(required=True)
    text = fields.Str(required=True)
    location = fields.Str(required=True)
    referrer = fields.Str(required=True)
    uatraits = fields.Str(required=True)


class BugMailHandler(ApiHandler):
    PARAMS_SCHEMA = BugMailParams

    def process(self, params, fields):
        c = SmailikClient(
            service='Flights.Yandex',
            send_from='avia-bug@mail.yandex-team.ru',
            smailik_dir='/var/spool/smailik-preparer/avia-backend/'
        )

        mesage = [
            params['text'],
            u'-------------------------------',
            'Client Info:',
            params['uatraits'],
            'Location:',
            params['location'],
            'Referrer:',
            params['referrer'],
        ]

        c.send_email(
            "avia-bug@yandex-team.ru",
            escape(u"Сообщение от %s@yandex.ru" % params['login']),
            '<br />'.join([s for s in mesage])
        )
