# -*- encoding: utf-8 -*-
from __future__ import absolute_import

from marshmallow import Schema, fields
from travel.avia.library.python.common.models.schedule import Company
from travel.avia.backend.main.api.api_handler import ApiHandler
from travel.avia.backend.main.api.api_schema import TypeSchema


class CompanySchema(TypeSchema):
    id = fields.Int()
    title = fields.Str(attribute='L_title')
    logo_svg = fields.Function(lambda c: c.svg_logo2 and c.svg_logo2.url or None)
    url = fields.Str()
    alliance = fields.Function(lambda c: c.alliance and c.alliance.id or None)
    color = fields.Str(attribute='logo_bgcolor')
    slug = fields.Str()


class AllianceSchema(TypeSchema):
    id = fields.Int()
    title = fields.Str()


class AirlineParams(Schema):
    id = fields.Int(required=False, allow_none=True)
    slug = fields.Str(required=False, allow_none=True)


class AirlineHandler(ApiHandler):
    PARAMS_SCHEMA = AirlineParams
    TYPE_SCHEMA = CompanySchema

    def process(self, params, fields):
        sql_params = None
        if params.get('id') is not None:
            sql_params = {'id': params['id']}
        else:
            if params.get('slug') is not None:
                sql_params = {'slug': params['slug']}

        if not sql_params:
            return None

        try:
            return Company.objects.get(**sql_params)
        except Company.DoesNotExist:
            return None
