# -*- encoding: utf-8 -*-
from __future__ import absolute_import

from marshmallow import fields

from travel.avia.backend.main.api.api_schema import TypeSchema
from travel.avia.backend.main.api.fields import Related
from travel.avia.backend.main.api.register import get_handler
from travel.avia.backend.main.api_types.price import PriceSchema


class CountryOfferSchema(TypeSchema):
    from_city = Related(handler=get_handler('settlement'), params={'settlement': 'city_from'})
    to_country = Related(handler=get_handler('country'), params={'country': 'country_to'})
    date_forward = fields.Date()
    date_backward = fields.Date()
    price = fields.Nested(PriceSchema)
