# -*- encoding: utf-8 -*-
from __future__ import absolute_import

import flask
from django.conf import settings

from travel.avia.library.python.avia_data.models import Currency

from travel.avia.backend.main.lib.rates import fetch_rates_info


def fetch_currency_info(national_version):
    rates = fetch_rates_info(national_version)

    order_map = settings.NATIONAL_CURRENCY_ORDERS[national_version]
    max_order = max(order_map.values()) + 1

    currencies = sorted(
        Currency.objects.all(),
        key=lambda currency: order_map.get(currency.code, max_order)
    )

    # Оставляем только валюты с курсом и названием
    available_codes = [
        currency.code
        for currency in currencies
        if (
            currency.L_name() and
            currency.L_name_in() and
            currency.code in rates
        )
    ]

    return {
        'rates': rates if len(rates) > 1 else None,
        'order': [c.code for c in currencies],
        'formats': {c.code: c.json() for c in currencies},
        'available': available_codes,
        'names': {
            c.code: {'name': c.L_name(), 'name_in': c.L_name_in()}
            for c in currencies
        }
    }


class CurrencyHandler(object):
    """ Судя по тому что код для этого не меняется годами - делать полноценное апи
        смысла нет. Пока что просто будем возвращать правильный json.
    """

    def __call__(self, params, fields):
        return fetch_currency_info(flask.g.national_version)
