# -*- encoding: utf-8 -*-
from __future__ import absolute_import

from flask import g
from marshmallow import Schema, fields

from travel.avia.library.python.common.models.partner import DohopVendor

from travel.avia.backend.main.api.api_handler import ApiHandler
from travel.avia.backend.main.api.api_schema import TypeSchema


class DohopVendorSchema(TypeSchema):
    id = fields.Int()
    dohop_id = fields.Int()
    title = fields.Method('get_title')

    def get_title(self, vendor):
        field = 'L_national_%s_title' % g.get('national_version')
        L_national_title = getattr(vendor, field, vendor.L_title)
        return L_national_title()


class DohopVendorsHandler(ApiHandler):
    PARAMS_SCHEMA = Schema
    TYPE_SCHEMA = DohopVendorSchema
    MULTI = True

    def process(self, params, fields):
        return DohopVendor.objects.filter(is_aviacompany=True, enabled=True)
