# -*- encoding: utf-8 -*-
from __future__ import absolute_import

from datetime import datetime
from marshmallow import Schema, fields

from travel.avia.library.python.avia_data.models import GoodPrice
from travel.avia.backend.main.api.api_handler import ApiHandler
from travel.avia.backend.main.api_types.price import get_passengers_key
from travel.avia.backend.main.lib import fields as api_fields
from travel.avia.backend.main.lib.prices import multiply_price


def key_to_pair(key):
    return key[:1], key[1:]


class GoodPricesParams(Schema):
    from_point_key = fields.Str(required=True)
    to_point_key = fields.Str(required=True)
    departure = api_fields.DateTime(required=True)
    # Строка объядиняющая все рейсы туда-обратно через ';'
    # Пример: SU 1413;SU 2502;SU 2503;SU 1406
    routes = fields.Str(reqiored=True)
    adult_seats = fields.Int(default=1)
    children_seats = fields.Int(default=0)
    infant_seats = fields.Int(default=0)


class GoodPriceSchema(Schema):
    q33 = fields.Int()
    q67 = fields.Int()


class GoodPricesHandler(ApiHandler):
    PARAMS_SCHEMA = GoodPricesParams
    TYPE_SCHEMA = GoodPriceSchema

    def process(self, params, fields):
        from_key = params.get('from_point_key')
        to_key = params.get('to_point_key')
        departure = params.get('departure')
        days = (departure - datetime.now()).days
        from_type, from_id = key_to_pair(from_key)
        to_type, to_id = key_to_pair(to_key)

        passengers_key = get_passengers_key(params)

        good_prices = GoodPrice.objects.filter(
            point_from_type=from_type,
            point_from_id=from_id,
            point_to_type=to_type,
            point_to_id=to_id,
            route_uid=params.get('routes'),
            days_to_flight=days,
            departure_weekday=departure.weekday()
        ).only('q33', 'q67').first()

        if not good_prices:
            return None

        return {
            "q33": multiply_price(good_prices.q33, passengers_key),
            "q67": multiply_price(good_prices.q67, passengers_key),
        }
