# -*- encoding: utf-8 -*-
from __future__ import absolute_import

from marshmallow import Schema, fields

from travel.avia.backend.main.models import AviaStaticPage

from travel.avia.backend.main.api.api_schema import TypeSchema
from travel.avia.backend.main.api.api_handler import ApiHandler


class InfoParams(Schema):
    slug = fields.Str(required=True)


class InfoSchema(TypeSchema):
    title = fields.Str(attribute='L_title')
    content = fields.Str(attribute='L_content')
    slug = fields.Str()
    template = fields.Str()

    meta_title = fields.Str(attribute='L_meta_title')
    meta_description = fields.Str(attribute='L_meta_description')

    type = fields.Str()
    children = fields.Nested('self', many=True)


class InfoHandler(ApiHandler):
    PARAMS_SCHEMA = InfoParams
    TYPE_SCHEMA = InfoSchema

    def process(self, params, fields):
        try:
            page = AviaStaticPage.get_page(
                slug=params.get('slug'),
                is_published__in=(1, 2),
                is_ticket_page=True
            )
        except AviaStaticPage.DoesNotExist:
            return None

        # Нельзя обращаться к страницам выше второго уровня
        if (len(page.materialized_path) / 3) > 2:
            return None

        if 'children' in fields:
            page.children = page.children().order_by('order', 'title')

        return page
