# -*- encoding: utf-8 -*-
from __future__ import absolute_import

from marshmallow import fields

from travel.avia.backend.main.api.api_schema import TypeSchema
from travel.avia.backend.main.api.fields import Related
from travel.avia.backend.main.api.register import get_handler
from .price import PriceSchema
from .settlement_image import SettlementImageSchema


class OfferSchema(TypeSchema):
    from_city = Related(handler=get_handler('settlement'), params={'settlement': 'city_from'})
    to_city = Related(handler=get_handler('settlement'), params={'settlement': 'city_to'})
    date_forward = fields.Date()
    date_backward = fields.Date()
    direct_price = fields.Nested(PriceSchema)
    transfers_price = fields.Nested(PriceSchema, attribute='indirect_price')
    price = fields.Nested(PriceSchema)
    image = fields.Nested(SettlementImageSchema)
