# -*- encoding: utf-8 -*-
from __future__ import absolute_import

from marshmallow import Schema, fields

from travel.avia.library.python.common.models.partner import PartnerUser

from travel.avia.backend.main.api.api_handler import ApiHandler
from travel.avia.backend.main.api.api_schema import TypeSchema


class PartnerLoginSchema(TypeSchema):
    login = fields.Str()
    role = fields.Str()
    partner_code = fields.Function(lambda obj: obj.partner.code if obj.partner else None)


class PartnersLoginsHandler(ApiHandler):
    PARAMS_SCHEMA = Schema
    TYPE_SCHEMA = PartnerLoginSchema
    MULTI = True

    def process(self, params, fields):
        return PartnerUser.objects.select_related('partner').all()
