# -*- encoding: utf-8 -*-
from __future__ import absolute_import

from marshmallow import Schema, fields, validate
from marshmallow.fields import Dict

from travel.avia.backend.main.api.api_schema import TypeSchema
from travel.avia.backend.main.api.fields import DatetimeAware, ListToDictField
from .company import AllianceSchema, CompanySchema
from .partners import PartnerSchema
from travel.avia.backend.main.api_types.price import PriceSchema
from .settlement import SettlementSchema
from .station import StationSchema


class FormBaseParams(Schema):
    when = fields.Date(allow_none=True)
    return_date = fields.Date(allow_none=True)
    adult_seats = fields.Integer(missing=1)
    children_seats = fields.Integer(missing=0)
    infant_seats = fields.Integer(missing=0)
    klass = fields.Str(missing='economy', validate=validate.OneOf(
        ['economy', 'business']
    ))


class FlightSchema(TypeSchema):
    key = fields.Str()
    number = fields.Str()
    company = fields.Int()
    from_ = fields.Int()
    to = fields.Int()
    avia_company = fields.Int()
    company_tariff = fields.Int()
    departure = DatetimeAware()
    arrival = DatetimeAware()
    t_model = fields.Str()


class ReferenceStationSchema(StationSchema):
    # Для сохранения апи передаём в поле settlement не объект, а id
    settlement = fields.Int(attribute='settlement_id')


class ReferenceCompanySchema(CompanySchema):
    # Для сохранения апи передаём в поле alliance не объект, а id
    alliance = fields.Int(attribute='alliance_id')


class ReferenceAviaCompanySchema(TypeSchema):
    id = fields.Int(attribute='pk')
    cost_type = fields.Str()
    carryon_width = fields.Int()
    carryon_height = fields.Int()
    carryon_length = fields.Int()
    baggage_rules = fields.Str()
    baggage_rules_url = fields.Str()
    baggage_dimensions_sum = fields.Int()


class ReferenceCompanyTariffsSchema(TypeSchema):
    id = fields.Int(required=True)
    avia_company = fields.Int()
    baggage_allowed = fields.Boolean()
    carryon = fields.Boolean()
    baggage_norm = fields.Float()
    carryon_norm = fields.Float()
    published = fields.Boolean()


class ReferenceSchema(TypeSchema):
    flights = ListToDictField(FlightSchema, key='key')
    itineraries = fields.Raw()
    settlements = ListToDictField(SettlementSchema, only=[
        'country_id', 'id', 'title', 'phrase_from', 'phrase_to', 'phrase_in'
    ])
    stations = ListToDictField(ReferenceStationSchema, only=[
        'title', 'phrase_to', 'phrase_in', 'phrase_from',
        't_type', 'station_type', 'code', 'settlement'
    ])
    companies = ListToDictField(ReferenceCompanySchema)
    avia_companies = ListToDictField(ReferenceAviaCompanySchema)
    company_tariffs = ListToDictField(ReferenceCompanyTariffsSchema)
    alliances = ListToDictField(AllianceSchema)
    partners = ListToDictField(PartnerSchema, key='code', only=[
        'id', 'title', 'logo_svg'
    ])
    settlement_to_count_stations = Dict()
    ratings = fields.Constant(dict())
    reviews_count = fields.Dict()


class VariantSchema(TypeSchema):
    forward = fields.Str()
    backward = fields.Str()
    partner = fields.Str()
    tariff = fields.Nested(PriceSchema)
    tag = fields.Str()
    choice = fields.Str()
    from_company = fields.Boolean()
    charter = fields.Boolean()
    query_time = fields.Float()
    expire_dt = DatetimeAware()
