# -*- encoding: utf-8 -*-
from __future__ import absolute_import

from cachetools.func import lru_cache
import flask
import random
from copy import copy

from marshmallow import Schema, fields

from travel.avia.library.python.avia_data.models import SettlementBigImage

from travel.avia.backend.main.api.api_handler import ApiHandler
from travel.avia.backend.main.api.api_schema import TypeSchema

_deafult_image_caches = None


@lru_cache(maxsize=None)
def get_default_images():
    return list(SettlementBigImage.objects.filter(settlement__isnull=True))


def get_default_image():
    """ Задача: я хочу, чтобы они выбирались случайно,
        а те что уже были выбраны не участвовали в выборе повторно,
        до тех пор, пока не закончатся все заглушки. """

    default_big_images = getattr(flask.g, '_default_big_images', None)
    if default_big_images is None:
        default_big_images = get_default_images()
        flask.g._default_big_images = default_big_images

    if not len(default_big_images):
        return None

    default_big_images_in_request = getattr(flask.g, '_default_big_images_in_request', [])
    if not len(default_big_images_in_request):
        default_big_images_in_request = copy(default_big_images)
        random.shuffle(default_big_images_in_request)
        flask.g._default_big_images_in_request = default_big_images_in_request

    return default_big_images_in_request.pop()


def get_settlement_images(settlements_ids):
    images = SettlementBigImage.objects.filter(settlement_id__in=set(settlements_ids))
    settlement_to_images = {image.settlement_id: image for image in images}

    result = []
    for settlement_id in settlements_ids:
        result.append(settlement_to_images.get(settlement_id) or get_default_image())

    return result


class SettlementImageParams(Schema):
    settlement_id = fields.Integer()


class SettlementImageSchema(TypeSchema):
    id = fields.Int()
    url2 = fields.Str(attribute='url2')


class SettlementImageHandler(ApiHandler):
    PARAMS_SCHEMA = SettlementImageParams
    TYPE_SCHEMA = SettlementImageSchema

    def preprocess_fields(self, fields):
        if not fields:
            return ['url2']

        return fields

    def process(self, params, fields):
        settlement_id = params.get('settlement_id', None)

        return get_settlement_images([settlement_id])[0]
