# -*- encoding: utf-8 -*-
from __future__ import absolute_import

from django.conf import settings
from marshmallow import Schema, fields, pre_dump

from travel.avia.library.python.common.models.partner import Partner, DohopVendor
from travel.avia.library.python.avia_data.models import AmadeusMerchant

from travel.avia.backend.main.api.api_handler import ApiHandler
from travel.avia.backend.main.api.api_schema import TypeSchema


class WizardPartnersSchema(TypeSchema):
    id = fields.Int()
    code = fields.Str()
    enabled = fields.Boolean()
    enabled_in_wizard = fields.Dict(fields.Boolean())
    is_aviacompany = fields.Bool()
    site_url = fields.Str()
    logos_svg = fields.Dict(fields.Str())
    icon_svg = fields.Str()
    titles = fields.Dict(fields.Str())
    billing_order_id = fields.Int()

    @pre_dump
    def get_icon_svg(self, partner):
        partner.icon_svg = partner.get_icon_svg()

    @pre_dump
    def get_logos_svg(self, partner):
        partner.logos_svg = {
            nv: partner.get_national_logo_svg(nv)
            for nv in settings.AVIA_WIZARD_NATIONAL_VERSIONS
        }

    @pre_dump
    def get_titles(self, partner):
        partner.titles = {
            nv: getattr(partner, 'L_national_{}_title'.format(nv), partner.L_title)()
            for nv in settings.AVIA_WIZARD_NATIONAL_VERSIONS
        }

    @pre_dump
    def get_enabled_in_wizard(self, partner):
        partner.enabled_in_wizard = {
            national: getattr(partner, 'enabled_in_wizard_{}'.format(national))
            for national in settings.AVIA_WIZARD_NATIONAL_VERSIONS
        }


class WizardPartnersHandler(ApiHandler):
    PARAMS_SCHEMA = Schema
    TYPE_SCHEMA = WizardPartnersSchema
    MULTI = True

    def process(self, params, fields):
        return tuple(
            Partner.objects.all()
        ) + tuple(
            DohopVendor.objects.all()
        ) + tuple(
            AmadeusMerchant.objects.all()
        )
