# -*- coding: utf-8 -*-
from __future__ import absolute_import

import logging
import subprocess
import time

from django.conf import settings
from django.core.management import BaseCommand

from travel.avia.backend.main.lib import file_flag

log = logging.getLogger(__name__)


class Command(BaseCommand):
    help = 'Set file-flag for ping views for <duration> seconds'

    def add_arguments(self, parser):
        parser.add_argument(
            '--before-restart-delay', action='store', type=int, default=10,
            dest='before_restart_delay', help='Pause before restarting for updating aliveness status'
        )
        parser.add_argument(
            '--after-restart-delay', action='store', type=int, default=40,
            dest='after_restart_delay', help='Additional pings-off gap after hup sent'
        )

    @staticmethod
    def pause_ping_responses(duration):
        filepath = settings.PAUSE_PING_RESPONSES_FLAGFILE
        log.info('Start: Set flag for %s seconds %s', duration, filepath)
        file_flag.set_temporary_flag(filepath, duration)
        assert file_flag.is_temporary_flag_up(filepath)

    def handle(self, *db_names, **options):
        try:
            pings_off_pause = options['before_restart_delay'] + options['after_restart_delay']
            log.info('Turn off ping views for %s seconds', pings_off_pause)
            self.pause_ping_responses(pings_off_pause)

            time.sleep(options['before_restart_delay'])

            subprocess.check_call(['supervisorctl', 'signal', 'HUP', 'gunicorn'])

            log.info('Restart launched')
            time.sleep(options['after_restart_delay'])
            log.info('Done')
        except Exception, e:
            log.exception('Exception: %r', e)
