from __future__ import absolute_import

from functools import wraps
from flask import request, Response


class BasicAuth(object):
    def __init__(self, username, password):
        self._username = username
        self._password = password

    def requires_auth(self, handler):
        @wraps(handler)
        def decorated(*args, **kwargs):
            return (
                handler(*args, **kwargs)
                if (
                    request.authorization
                    and request.authorization.username == self._username
                    and request.authorization.password == self._password
                )
                else Response(
                    status=401,
                    headers={
                        'WWW-Authenticate': 'Basic realm="Login Required"'
                    }
                )
            )

        return decorated
