# -*- coding: utf-8 -*-
from __future__ import absolute_import

import logging

from django.conf import settings

from travel.library.python.tvm_ticket_provider import provider_fabric

log = logging.getLogger(__name__)

try:
    from blackbox import XmlBlackbox, BlackboxError
    blackbox = XmlBlackbox(
        url=settings.BLACKBOX_URL
    )

except Exception:
    log.critical('Blackbox error', exc_info=True)
    blackbox = None


def get_uid(login):
    if not blackbox:
        raise BlackboxError('No blackbox')

    tvm_client = provider_fabric.create(
        source_id=settings.TVM_SERVICE_ID,
        secret=settings.TVM_TOKEN,
        destinations=['blackbox'],
    )

    return blackbox.uid(
        login,
        headers={
            'X-Ya-Service-Ticket': tvm_client.get_ticket('blackbox'),
        },
    )
