# -*- coding: utf-8 -*-
from __future__ import absolute_import

import logging

from django.core.cache import caches

from travel.avia.library.python.common.utils.memcache_backend import MemcachedCache

from travel.avia.backend.main.lib.timer import Timer


log = logging.getLogger(__name__)


class LoggingMcrouterCache(MemcachedCache):
    """
    Бэкенд для mcrouter, логирующий времена set, get
    """

    def set(self, key, *args, **kwargs):
        timer = Timer()
        super(LoggingMcrouterCache, self).set(key, *args, **kwargs)
        log.info('memcache set %s %s', timer.elapsed.total_seconds(), key)

    def set_many(self, *args, **kwargs):
        timer = Timer()
        super(LoggingMcrouterCache, self).set_many(*args, **kwargs)
        log.info('memcache set_many %s', timer.elapsed.total_seconds())

    def get(self, key, *args, **kwargs):
        timer = Timer()
        result = super(LoggingMcrouterCache, self).get(key, *args, **kwargs)
        log.info('memcache get %s %s', timer.elapsed.total_seconds(), key)
        return result


shared_cache = caches['shared_cache']
default_cache = caches['default']
