# -*- coding: utf-8 -*-
from __future__ import absolute_import

from contextlib import contextmanager
from decorator import decorator


@contextmanager
def closing_db():
    from django import db
    db.reset_queries()
    try:
        yield
    finally:
        db.close_old_connections()


@decorator
def with_closing_db(func, *args, **kwargs):
    """Сохраняющий сигнатуру функции декоратор обычной функции"""
    with closing_db():
        return func(*args, **kwargs)
