# -*- encoding: utf-8 -*-
from __future__ import absolute_import

import sys
import traceback
from logging import getLogger
from flask import request

log = getLogger('api')


class ResponseException(Exception):
    """ специальный тип исключения когда его нужно пробросить в ответ """
    pass


class ApiException(Exception):
    def __init__(self, msg='Api error', errors=None, is_critical=True):
        self.message = unicode(msg)
        self.errors = errors
        self.request = request
        self.is_critical = is_critical

        if not isinstance(msg, Exception):
            return

        if isinstance(msg, ResponseException):
            return

        exception, value, tb = sys.exc_info()
        self.message = u','.join([
            line.strip()
            for line in traceback.format_exception_only(exception, value)
        ])

        str_tb = u''.join([line.strip().decode('utf8') for line in traceback.format_tb(tb, 3)])
        if str_tb:
            self.errors = {
                'traceback': str_tb
            }

    def _make_description(self):
        if isinstance(self.errors, dict):
            return self.errors

    def dump(self):
        response = {
            'status': 'error',
            'reason': self.message,
        }

        if self.errors:
            response['description'] = self._make_description()

        if self.request:
            response['args'] = self.request.args
            response['request'] = self.request.get_json()

        if self.is_critical:
            log.exception(response)
        else:
            log.warn(response)

        return response
