# -*- coding: utf-8 -*-
from __future__ import absolute_import

from contextlib2 import suppress
from datetime import datetime

from marshmallow import fields


class DateTime(fields.DateTime):
    def _deserialize(self, value, attr, data, **kwargs):
        """(RASPTICKETS-17963) for compatibility with marshmallow==2.4.0"""
        with suppress(Exception):
            return datetime.strptime(value, '%Y-%m-%d')
        return super(DateTime, self)._deserialize(value, attr, data, **kwargs)
