# -*- coding: utf-8 -*-
from __future__ import absolute_import

import os
import time
from datetime import datetime, timedelta


def get_flag_info(flag_file_path):
    """
    Returns flag_creation_time, flag_content
    """
    if not os.path.exists(flag_file_path):
        return None, None
    mtime = os.path.getmtime(flag_file_path)
    with open(flag_file_path, 'rb') as f:
        return datetime(*time.localtime(mtime)[:6]), f.read()


def update_flag(flag_file_path, content=None):
    with open(flag_file_path, 'wb') as f:
        f.write('{}'.format(content) or '\n')


def set_temporary_flag(flag_file_path, ttl_seconds):
    update_flag(flag_file_path, str(ttl_seconds))


def is_temporary_flag_up(flag_file_path):
    mtime, content = get_flag_info(flag_file_path)
    if not mtime:
        return False
    expire_time = mtime + timedelta(seconds=int(content))
    return expire_time > datetime.now()
