# -*- coding: utf-8 -*-
from __future__ import absolute_import

from travel.avia.backend.main import settings
from travel.avia.backend.main.services import price_index
from travel.avia.backend.main.services.price_index import PriceIndex


def search(holiday, from_city, national_version, window_size=0, results_per_direction=2):
    empty_result = {
        holiday.pk: []
    }
    directions = [
        price_index.FromTo(direction.from_settlement_pk, direction.to_settlement_pk)
        for direction in holiday.holiday_directions if direction.from_settlement_pk == from_city.id
    ]

    if not directions:
        return empty_result

    response = PriceIndex(settings.AVIA_PRICE_INDEX_URL).search(
        directions=directions,
        national_version=national_version,
        forward_date=holiday.start_day,
        backward_date=holiday.end_day,
        window_size=window_size,
        results_per_direction=results_per_direction
    )

    return {
        holiday.pk: response
    }
