from __future__ import absolute_import

from django.core.exceptions import ObjectDoesNotExist

from travel.avia.library.python.common.models.partner import Partner, PartnerUser

from travel.avia.backend.main.lib.blackbox_utils import get_uid


def create_partner_user(role, login, name, partner_code):
    puid = get_uid(login)
    if not puid:
        raise ValueError('No passportuid for {}'.format(login))

    partner = None
    if partner_code:
        try:
            partner = Partner.objects.get(code=partner_code)
        except ObjectDoesNotExist:
            raise ValueError('Partner not found for code {}'.format(partner_code))

    user = PartnerUser(
        login=login,
        role=role,
        passportuid=puid,
        name=name,
        partner=partner,
    )

    user.clean()
    user.save(using='writable')
