# -*- encoding: utf-8 -*-
from __future__ import absolute_import

import inspect
import os
import cProfile
import pstats
from datetime import datetime


def profile(func):
    def wrapper(*args, **kwargs):
        pr = cProfile.Profile()
        pr.enable()

        result = func(*args, **kwargs)

        pr.disable()

        arg_spec = inspect.getargspec(func)
        if 'self' in arg_spec.args:
            class_name = args[0].__class__.__name__
            func_name = func.__name__
            f_name = '%s_%s' % (class_name, func_name)
        else:
            f_name = func.__name__

        f_name = "%s_%s.prof" % (f_name, datetime.now())
        main_dir = os.path.abspath(os.path.join(os.path.dirname(__file__), '../..'))
        f_path = os.path.join(main_dir, 'log', f_name)

        with open(f_path, 'w') as f:
            sortby = 'cumulative'
            pstats.Stats(pr, stream=f).strip_dirs().sort_stats(sortby).print_stats()

        return result

    return wrapper
