from __future__ import absolute_import

from travel.avia.library.python.common.utils import environment
from travel.avia.backend.repository.recipe import recipes_repository


class RecipeProvider(object):
    def __init__(self, environment, recipes_repository):
        self._environment = environment

        self._recipes_repository = recipes_repository

    def get_by_id(self, recipe_id, settlement, national_version):
        recipe = self._recipes_repository.get_by_id(recipe_id)
        if recipe is None:
            return None

        if self._filter_actual([recipe], settlement, national_version):
            return recipe
        return None

    def get_actual(self, settlement, national_version):
        recipes = self._recipes_repository.get_all()

        recipes = self._filter_actual(recipes, settlement, national_version)

        return recipes

    def _filter_actual(self, recipes, settlement, national_version):
        now = self._environment.today()

        return [
            r for r in recipes
            if (
                r.enabled_by_nv.get(national_version) and
                (
                    not r.from_settlement_ids or
                    settlement.pk in r.from_settlement_ids
                ) and
                (
                    not r.from_region_ids or
                    settlement.region_id in r.from_region_ids
                ) and
                (
                    r.show_start is None or (
                        (
                            r.show_year is True and
                            r.show_start <= now
                        ) or
                        (
                            r.show_year is False and
                            r.show_start.strftime('%m-%d') <= now.strftime(
                                '%m-%d')
                        )
                    )
                )
                and
                (
                    r.show_end is None or (
                        (
                            r.show_year is True and
                            r.show_end >= now
                        ) or
                        (
                            r.show_year is False and
                            r.show_end.strftime('%m-%d') >= now.strftime(
                                '%m-%d')
                        )
                    )
                )
            )
        ]


recipe_provider = RecipeProvider(
    environment=environment,
    recipes_repository=recipes_repository
)
