# -*- coding: utf-8 -*-
from __future__ import absolute_import

from django.conf import settings

from travel.avia.library.python.common.models.geo import Country

from travel.avia.backend.main.lib.geo import get_capital
from travel.avia.backend.main.lib.recipes.recipe_direction_finder import find as find_directions


def _get_recipe_directions(recipe, city_from, when, return_date, passengers_key, national_version, limit):
    directions = find_directions(city_from, recipe, when, return_date, national_version, limit)

    for d in directions:
        d.passengers_key = passengers_key

    return directions


def get_recipe_offers(recipe, city_from, when, return_date, passengers, national_version, limit):
    passengers_key = '_'.join([
        str(passengers.get('adult_seats', 1)),
        str(passengers.get('children_seats', 0)),
        str(passengers.get('infant_seats', 0)),
    ])
    directions = _get_recipe_directions(recipe=recipe,
                                        city_from=city_from,
                                        when=when,
                                        return_date=return_date,
                                        passengers_key=passengers_key,
                                        national_version=national_version,
                                        limit=limit)

    if directions:
        return directions

    # Если ничего не найдено, логика "дополнения" подобная популярным направления
    # сначала ищем от столицы области
    capital = None

    if city_from.region:
        capital = city_from.region.get_capital()

        # Учитываем флаг "Не показывать нигде"
        if capital and not capital.hidden:
            directions = _get_recipe_directions(recipe=recipe,
                                                city_from=capital,
                                                when=when,
                                                return_date=return_date,
                                                passengers_key=passengers_key,
                                                national_version=national_version,
                                                limit=limit)

    if directions:
        return directions

    # а если там ничего нет, то от столицы страны
    country = city_from.country

    # фолбечим на столицу нац версии
    if not country:
        country_id = settings.NATIONAL_VERSION_COUNTRY_MAP.get(national_version)
        country = Country.objects.get(id=country_id)

    country_capital = get_capital(country, national_version)

    if country_capital and country_capital != capital:
        directions = _get_recipe_directions(recipe=recipe,
                                            city_from=country_capital,
                                            when=when,
                                            return_date=return_date,
                                            passengers_key=passengers_key,
                                            national_version=national_version,
                                            limit=limit)

    return directions
