# -*- coding: utf-8 -*-
from __future__ import absolute_import

from django.db.models import Q

from travel.avia.library.python.common.models.geo import Settlement


def filter_geo(recipe, city_from):
    country_ids = list(recipe.countries.all().values_list('id', flat=True))
    region_ids = list(recipe.regions.all().values_list('id', flat=True))
    settlement_ids = list(recipe.settlements.all().values_list('id', flat=True))

    if city_from.id in settlement_ids:
        settlement_ids.remove(city_from.id)

    if city_from.region and city_from.region.id in region_ids:
        region_ids.remove(city_from.region.id)

    if not country_ids and not region_ids and not settlement_ids:
        return {}

    settlement_ids += list(Settlement.hidden_manager.filter(
        Q(country__in=country_ids) | Q(region__in=region_ids)
    ).values_list('id', flat=True))

    # Город может вернуться из геобазы
    if city_from.id in settlement_ids:
        settlement_ids.remove(city_from.id)

    if city_from.region and city_from.region.id in region_ids:
        region_ids.remove(city_from.region.id)

    if not settlement_ids:
        return {}

    return {
        'arrival_settlement_id__in': list(set(settlement_ids))
    }


def filter_weekdays(recipe):
    week_days = filter(lambda x: x, recipe.week_days.split(','))
    week_days = [(int(i.strip()) - 1) for i in week_days]

    if week_days:
        day_filter = Q()

        for day in week_days:
            day_filter |= Q(day_of_week=day)

        return [day_filter]

    return []
