# coding=utf-8
from __future__ import absolute_import

from collections import defaultdict

from travel.avia.library.python.common.models.geo import Station, Settlement
from travel.avia.library.python.common.models.transport import TransportType


def get_settlements_airports_with_iata(settlement_ids):
    u"""
    Берутся только аэропорты находящиеся в указаных городах.
    :param settlement_ids:
    """

    airports = defaultdict(list)
    stations = Station.objects.filter(
        settlement__id__in=settlement_ids,
        hidden=False,
        t_type=TransportType.PLANE_ID
    )

    for s in stations:
        # Для определения iata и sirena_id делаются отдельные запросы к базе
        if s.iata or s.sirena_id:
            airports[s.settlement.id].append(s)

    return airports


def get_settlement_from_point(point):
    if isinstance(point, Station):
        point = point.settlement
    elif not isinstance(point, Settlement):
        return None

    return point
