# -*- encoding: utf-8 -*-
from __future__ import absolute_import

import locale
from logging import getLogger

from flask import request, g
from django.utils import translation

log = getLogger(__name__)


def _set_collate_locale(locale_key):
    try:
        locale.setlocale(locale.LC_COLLATE, locale_key)
    except locale.Error:
        locale.setlocale(locale.LC_COLLATE, 'C')
        log.error(u'Не удалось установить локаль %s' % locale_key)


def localize():
    g.lang = lang = request.args.get('lang', 'ru')
    national_version = request.args.get('national_version', 'ru')

    if national_version in ('ua', 'ru'):
        _set_collate_locale('ru_RU.UTF8')  # Правильно сортируем украинские строки

    elif national_version == 'tr':
        _set_collate_locale('tr_TR.UTF8')  # Правильно сортируем турецкие строки

    elif national_version == 'com':
        _set_collate_locale('en_GB.UTF8')  # Правильно сортируем английские строки

    translation.activate(lang)
    g.national_version = national_version
