# -*- coding: utf-8 -*-
from __future__ import absolute_import, unicode_literals

from datetime import datetime

from travel.avia.library.python.common.utils.date import MSK_TZ


class WsgiMiddleware(object):
    def __init__(self, app):
        self.app = app

    def __call__(self, environ, start_response):
        return self.app(environ, start_response)


class HTTPSchemeProxy(WsgiMiddleware):
    def __call__(self, environ, start_response):
        scheme = environ.get('HTTP_X_FORWARDED_PROTOCOL', '')

        if scheme:
            environ['wsgi.url_scheme'] = scheme

        return self.app(environ, start_response)


class Now(WsgiMiddleware):
    def __call__(self, environ, start_response):
        now = datetime.now()
        environ['now'] = environ['msk_now'] = MSK_TZ.localize(now)
        environ['naive_msk_now'] = environ['msk_now'].replace(tzinfo=None)

        return self.app(environ, start_response)
