# -*- coding: utf-8 -*-
from __future__ import absolute_import

import flask
from django.db import models
from django.conf import settings
from django.utils.translation import ugettext_lazy as _

from travel.avia.library.python.common.models_utils.i18n import L_field


class AviaStaticPage(models.Model):
    u""" Статические страницы """
    parent = models.ForeignKey('self', verbose_name=_(u"родитель"), null=True, blank=True)
    L_title = L_field(verbose_name=_(u"название"), max_length=200, add_local_field=True)
    slug = models.CharField(verbose_name=_(u"код"), max_length=200, null=True, blank=True)
    VISIBILITY_TYPES = (
        (0, _(u'Скрыта')),
        (1, _(u'Опубликована')),
        (2, _(u'Устарела')),
    )
    is_published = models.IntegerField(choices=VISIBILITY_TYPES,
                                       verbose_name=_(u"опубликовано"), default=0)
    L_content = L_field(verbose_name=_(u"содержание"), add_local_field=True,
                        field_cls=models.TextField, default=None, null=True, blank=True)
    template = models.CharField(verbose_name=_(u"файл шаблона"), max_length=200,
                                help_text=_(u'например "yandex_dengi.html"'),
                                null=True, blank=True)
    order = models.IntegerField(verbose_name=_(u"порядок"), default=0)
    materialized_path = models.CharField(verbose_name=_(u"родители"), max_length=200,
                                         help_text=_(u'materialized path'), default='',
                                         null=True, blank=True)

    PAGE_TYPES = (
        ('page', _(u'Обычная страница')),
        ('template', _(u'Jinja шаблон')),
        ('link', _(u'Ссылка на внешнюю страницу')),
        ('geo', _(u'Страница стран')),
        ('carrier', _(u'Страница перевозчиков по странам')),
        ('transport', _(u'Страница типов ТС')),
    )
    type = models.CharField(choices=PAGE_TYPES, max_length=10, default='page', blank=False, null=False)

    is_ticket_page = models.BooleanField(verbose_name=_(u'страница из КБ?'), default=False)

    L_meta_title = L_field(max_length=255, verbose_name=_(u'title страницы'), add_local_field=True, default=None)
    L_meta_description = L_field(verbose_name=_(u'meta description страницы'), field_cls=models.TextField,
                                 add_local_field=True, default=None, null=True, blank=True)

    national_version = models.CharField(choices=settings.DOMAIN_TO_NATIONAL_VERSION.items(),
                                        max_length=25,
                                        default='ru',
                                        verbose_name=_(u'Национальная версия'))

    @classmethod
    def get_page(cls, **selectors):
        return cls.objects.filter(is_ticket_page=True,
                                  national_version=flask.g.national_version).get(**selectors)

    def __unicode__(self):
        return self.title

    def children(self):
        return AviaStaticPage.objects.filter(
            parent_id=self.id,
            is_published=True,
        )

    class Meta:
        app_label = 'avia_data'
        db_table = 'staticpages_staticpage'
        ordering = ('materialized_path',)
        verbose_name = _(u'статическая страница')
        verbose_name_plural = _(u'статические страницы')
