# Описание ручки
Ручка возвращает списки авиакомпании, сгруппированных по первой букве.
Авиакомпании отсортированны по алфавиту внутри каждого списка

## Формат запроса:
```
'/rest/airlines/abc/<national_version>/<lang>/<start>/<end>'
```
*national_version* - национальная версия
*lang* - язык интерфейса пользователя
*start* - с какой буквы начать формировать списки
*end* - на какой букве заканчивать формировать список

## Формат ответа:

```
https://<host>/rest/airlines/abc/ru/ru/%D0%B0/%D1%8F
{
  "status": "ok",
  "data": [
    {
      "airlines": [
        {
          "slug": "su_aurora",
          "id": 58388,
          "title": "Аврора (ZZ)"
        }
        {
          "slug": "ak-yamal",
          "id": 202,
          "title": "АК Ямал"
        }
      ],
      "letter": "а"
    },
    {
      "airlines": [
      ],
      "letter": "б"
    }
  ]
}
```


## Особенности:

Список первых букв ограничен двумя алфавитами: русским и английским.
*start* и *end* при запросе должны входить в один из словарей оба, то есть не может быть так, что *start* был в русском словаре, а *end* в английсом

*start* должен быть меньше или равен *end*  в лексеграфическом порядке

Если для буквы X нет авиакомпаний, то будет возвращен пустой лист для этой буквы, то есть в последовательности нет дырок.

Заголовок состоит из названия авиакомпании и кода(iata/sirena). Код может отсутсвовать.

Если название авикомпании отсутвует для переданного *lang* или первая буква не содержится в обоих алфавитах, то данная авиакомпания не будет возвращена



