# coding=utf-8
from __future__ import absolute_import

from travel.avia.backend.repository.airlines import AirlineRepository, airline_repository  # noqa


class AbcAirlineProvider(object):
    RUSSIAN_ABC_LETTERS = u'абвгдеёжзийклмнопрстуфхцчшщъыьэюя'
    ABC_LETTERS = u'abcdefghijklmnopqrstuvwxyz'

    def __init__(self, airline_repository):
        # type: (AirlineRepository) -> None
        self._airline_repository = airline_repository

    def get_airlines_by_letter(self, lang):
        airlines = self._airline_repository.get_all()

        airlines_by_letter = {}
        for letter in self.RUSSIAN_ABC_LETTERS + self.ABC_LETTERS:
            airlines_by_letter[letter] = []

        for airline in airlines:
            letter = self.get_first_letter(airline, lang)
            if letter not in airlines_by_letter:
                continue
            airlines_by_letter[letter].append(airline)

        return airlines_by_letter

    def get_first_letter(self, airline, lang):
        title = airline.get_title(lang)
        return title[0].lower() if title else None


abc_airline_provider = AbcAirlineProvider(
    airline_repository=airline_repository
)
