# Описание ручки
Ручка возвращает 2 списка групп авиакомпаний, объединенных первой буквой из названия.
В первом списке лежит группировка  по русским буквам, во втором группировака по английским буквам.
Каждый элемент списка в себе содержит:
count - количество авиакомпаний принадлежащей этой группе.
letter - первая буква из названия авиакомпаний, принаджлежущищ этой группе.

## Формат запроса:
```
'/rest/airlines/index/<national_version>/<lang>'
```
*national_version* - национальная версия
*lang* - язык интерфейса пользователя

## Формат ответа:

```
https://<host>/rest/airlines/index/ru/ru
{
  "status": "ok",
  "data": {
    "abc_index": [
      {
        "count": 125,
        "letter": "a"
      },
      {
        "count": 29,
        "letter": "b"
      },
      ...
      {
        "count": 3,
        "letter": "y"
      },
      {
        "count": 3,
        "letter": "z"
      }
    ],
    "russian_abc_index": [
      {
        "count": 9,
        "letter": "а"
      },
      ...
      {
        "count": 3,
        "letter": "ю"
      },
      {
        "count": 2,
        "letter": "я"
      }
    ]
  }
}
```


## Особенности:
Каждый из списков не сожержит в себе дырок. Если в какой-то группе нет ни одной авиакомпании, то в списке группа все равно будет присутствовать
