# coding=utf-8
from __future__ import absolute_import

from logging import getLogger, Logger  # noqa
from marshmallow import Schema, fields

from travel.avia.backend.main.rest.airlines.helpers import AbcAirlineProvider, abc_airline_provider  # noqa
from travel.avia.backend.main.rest.helpers import CommonView


class AirlineIndexForm(Schema):
    national_version = fields.String(required=True)
    lang = fields.String(required=True)


class AirlineIndexView(CommonView):
    def __init__(self, abc_airline_provider, logger):
        # type: (AbcAirlineProvider, Logger) -> None
        super(AirlineIndexView, self).__init__(AirlineIndexForm(), logger)
        self._abc_airline_provider = abc_airline_provider

    def _process(self, parsed_data):
        lang = parsed_data[u'lang']
        airlines_by_letter = self._abc_airline_provider.get_airlines_by_letter(lang)

        return {
            u'russian_abc_index': self._partial_index(
                letters=self._abc_airline_provider.RUSSIAN_ABC_LETTERS,
                airlines_by_letter=airlines_by_letter
            ),
            u'abc_index': self._partial_index(
                letters=self._abc_airline_provider.ABC_LETTERS,
                airlines_by_letter=airlines_by_letter
            )
        }

    def _partial_index(self, letters, airlines_by_letter):
        return [
            {
                u'letter': letter,
                u'count': len(airlines_by_letter[letter])
            } for letter in letters
        ]


airline_index_view = AirlineIndexView(
    abc_airline_provider=abc_airline_provider,
    logger=getLogger(__name__)
)
